<?php
require_once 'header.php';

if(!$usersObject->ID()) {
	header("Location: /");
	exit;
}

$user = $usersObject->details();

?>

<div class="container ctwhite">

	<h1><?=translate('my_account') ?>!</h1>
	
	<form method="post" action="<?php print SITE; ?>/ajax/account.php" id="account-form">
		<label>
			<?=translate('full_name')?>:
		</label>
		<input type="text" name="full_name" value="<?php print htmlspecialchars($user->full_name); ?>" class="required" autocomplete="off"/>
		
		<br/>
		
		<label>
			<?=translate('email')?>:
		</label>
		<input type="email" name="email" value="<?php print $user->email; ?>" class="required" autocomplete="off"/>
		
		<br/>
		
		<label>
			PayPal <?=translate('email')?>:
		</label>
		<input type="email" name="paypal_email" value="<?php print $user->paypal_email; ?>" class="required" autocomplete="off"/>
		
		<br/>
		
		<label>
			<?=translate('password')?> <span class="muted">(<?=translate('change_password')?>):</span>
		</label>
		<input type="password" name="password" class="required" />
		
		<br/>
		
		<input type="submit" name="sb_account" value="<?=translate('update_account')?>" class="btn btn-info"/>
	
	</form>
	
	<div id="signup_output"></div>
		
</div>

<?php
require_once 'footer.php';
?>